/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed Materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2004  All Rights Reserved.
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
************************************************************ {COPYRIGHT-END} **/

/**
 * Static, Singleton Constructor
 */
if ( !self.WToggleButton )
{
    self.WToggleButton = new WToggleButtonImpl();
}

function WToggleButtonImpl()
{
    this.toggle          = WToggleButton_toggle;
    this.init            = WToggleButton_init;
    this.handleMouseOver = WToggleButton_handleMouseOver;
    this.handleMouseOut  = WToggleButton_handleMouseOut;
}

function WToggleButton_toggle( buttonName )
{
    var button = document.getElementById( buttonName );

    if ( button.isToggled )
    {
        if ( !button.groupName )
        {
            button.isToggled = false;
            button.className = button.offStyle;
        }
    }
    else
    {
        if ( button.groupName )
        {
            var currentActiveButtonName = eval( "self." + button.groupName );

            var currentActiveButton = document.getElementById( currentActiveButtonName );
            
            if ( currentActiveButton != null )
            {
	            currentActiveButton.isToggled = false;
	
	            currentActiveButton.className = currentActiveButton.offStyle;
	        }

            eval( "self." + button.groupName + "= new String('"+buttonName+"')" );
        }

        button.isToggled = true;
        button.className = button.onStyle;
    }

}

function WToggleButton_init( buttonName
                           , buttonGroupName
                           , isToggledOn
                           , onStyle
                           , offStyle
                           , mouseOverStyleOn
                           , mouseOverStyleOff )
{
    var button = document.getElementById( buttonName );
    if ( button )
    {
        button.groupName = buttonGroupName;

        if ( isToggledOn && button.groupName )
        {
            eval( "self." + buttonGroupName + "= new String('"+buttonName+"')" );
        }

        button.isToggled      = isToggledOn;
        button.onStyle        = onStyle;
        button.offStyle       = offStyle;
        button.mouseOverStyleOn = mouseOverStyleOn;
        button.mouseOverStyleOff = mouseOverStyleOff;
    }
    else
    {
        var count = WToggleButton_init.arguments[7];
        if ( !count )
        {
            count = 0;
        }
        // only recurse for 30 seconds
        if ( count < 30000 )
        {
            count++;
            setTimeout( "WToggleButton.init('"+buttonName+"','"+buttonGroupName+"',"+isToggledOn+",'"+onStyle+"','"+offStyle+"','"+mouseOverStyleOn+"','"+mouseOverStyleOff+"',"+count+")", 100 );
        }
    }
}

function WToggleButton_handleMouseOver( buttonName )
{
    var button = document.getElementById( buttonName );

    if ( button.isToggled )
    {
        button.className = button.mouseOverStyleOn;
    }
    else
    {
        button.className = button.mouseOverStyleOff;
    }
}

function WToggleButton_handleMouseOut( buttonName )
{
    var button = document.getElementById( buttonName );

    if ( button.isToggled )
    {
        button.className = button.onStyle;
    }
    else
    {
        button.className = button.offStyle;
    }
}


